/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMMapStats;
import filenet.sim.animationdp.IVWSIMWorkClassStats;
import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.MapStats;
import filenet.sim.animationdp.impl2.StatObj;
import filenet.sim.animationdp.impl2.Statistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class WorkClassStats
extends StatObj
implements IVWSIMWorkClassStats {
    private int id;
    private String name;
    private int nLaunched = 0;
    private long minCycle = 0L;
    private long maxCycle = 0L;
    private double avgCycle = 0.0;
    private Hashtable mapStats = new Hashtable(1);
    private transient Statistics m_stats = null;
    private transient AnimationManager m_manager = null;

    public int getWorkClassId() {
        return this.id;
    }

    public String getWorkflowName() {
        return this.name;
    }

    public int getLaunchedWorkflowCount() {
        return this.nLaunched;
    }

    public int getCompletedWorkflowCount() {
        return this.nCompleted;
    }

    public int getActiveWorkflowCount() {
        return this.nActive;
    }

    public int getOverdueWorkflowCount() {
        return this.nOverdue;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public double getAverageCost() {
        return this.avgCost;
    }

    public long getMinCycleTimeForCompletedWorkflow() {
        return this.minCycle;
    }

    public long getMaxCycleTimeForCompletedWorkflow() {
        return this.maxCycle;
    }

    public double getAvgCycleTimeForCompletedWorkflow() {
        return this.avgCycle;
    }

    public IVWSIMMapStats[] getMapsStats() {
        return this.mapStats.values().toArray(new IVWSIMMapStats[0]);
    }

    protected String getId() {
        return Integer.toString(this.id);
    }

    public void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.nCompleted = in.readInt();
        this.nActive = in.readInt();
        this.nOverdue = in.readInt();
        this.totalCost = in.readDouble();
        this.avgCost = in.readDouble();
        this.id = in.readInt();
        this.name = in.readUTF();
        this.nLaunched = in.readInt();
        this.minCycle = in.readLong();
        this.maxCycle = in.readLong();
        this.avgCycle = in.readDouble();
        int count = in.readInt();
        while (count-- > 0) {
            MapStats m = new MapStats();
            m.readFromStream(in);
            MapStats curM = (MapStats)this.mapStats.get(m.getId());
            if (curM == null) {
                curM = m;
            } else {
                curM.merge(m);
            }
            this.mapStats.put(m.getId(), curM);
        }
    }

    protected void merge(WorkClassStats wc) {
        this.nCompleted = wc.nCompleted;
        this.nActive = wc.nActive;
        this.nOverdue = wc.nOverdue;
        this.totalCost = wc.totalCost;
        this.avgCost = wc.avgCost;
        this.nLaunched = wc.nLaunched;
        this.minCycle = wc.minCycle;
        this.maxCycle = wc.maxCycle;
        this.avgCycle = wc.avgCycle;
        for (MapStats theirM : wc.mapStats.values()) {
            MapStats myM = (MapStats)this.mapStats.get(theirM.getId());
            if (myM == null) {
                myM = theirM;
            } else {
                myM.merge(theirM);
            }
            this.mapStats.put(theirM.getId(), myM);
        }
    }

    public void toString(StringBuffer buf) {
        buf.append("\n<WC id=\"").append(this.id).append("\" name=\"").append(this.name).append("\" nActive=\"").append(this.nActive).append("\" nCompleted=\"").append(this.nCompleted).append("\" nOverdue=\"").append(this.nOverdue).append("\" avgCost=\"").append(this.avgCost).append("\" totalCost=\"").append(this.totalCost).append("\" avgCycle=\"").append(this.avgCycle).append("\" minCycle=\"").append(this.minCycle).append("\" maxCycle=\"").append(this.maxCycle).append("\">\n<Maps>");
        Iterator iter = this.mapStats.values().iterator();
        while (iter.hasNext()) {
            ((MapStats)iter.next()).toString(buf);
        }
        buf.append("\n</Maps></WC>");
    }

    protected int getToStringSize() {
        int size = 128;
        Iterator iter = this.mapStats.values().iterator();
        while (iter.hasNext()) {
            size += ((MapStats)iter.next()).getToStringSize();
        }
        return size;
    }

    public void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("WC_STATS.1.0");
        out.writeInt(this.nCompleted);
        out.writeInt(this.nActive);
        out.writeInt(this.nOverdue);
        out.writeDouble(this.totalCost);
        out.writeDouble(this.avgCost);
        out.writeInt(this.id);
        out.writeUTF(this.name);
        out.writeInt(this.nLaunched);
        out.writeLong(this.minCycle);
        out.writeLong(this.maxCycle);
        out.writeDouble(this.avgCycle);
        out.writeInt(this.mapStats.size());
        for (MapStats m : this.mapStats.values()) {
            m.writeToStream(out);
        }
    }
}

